<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Tender Document</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 12px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
        }

        .logo {
            max-height: 60px;
            margin-bottom: 10px;
        }

        .society-name {
            font-size: 20px;
            font-weight: bold;
            margin: 0;
        }

        .society-address {
            font-size: 11px;
            margin: 5px 0;
            color: #555;
        }

        .title-box {
            text-align: center;
            margin-bottom: 20px;
        }

        .doc-title {
            font-size: 16px;
            font-weight: bold;
            text-decoration: underline;
            text-transform: uppercase;
        }

        .meta-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .meta-table th,
        .meta-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .meta-table th {
            background-color: #f4f4f4;
            width: 35%;
        }

        .section {
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 5px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 3px;
        }

        .content {
            text-align: justify;
            line-height: 1.5;
        }

        .footer {
            margin-top: 50px;
            text-align: right;
        }

        .sign {
            border-top: 1px solid #333;
            display: inline-block;
            padding-top: 5px;
            width: 200px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="header">
        <?php if($tender->society_logo): ?>
            <img src="<?php echo e($tender->society_logo); ?>" class="logo" alt="Logo">
        <?php endif; ?>
        <h1 class="society-name"><?php echo e($tender->society_name ?? 'Society Management'); ?></h1>
        <p class="society-address"><?php echo e($tender->society_address ?? 'Official Address'); ?></p>
    </div>

    <div class="title-box">
        <div class="doc-title">Tender Notice</div>
        <div>Ref No: <?php echo e($tender->tender_number); ?></div>
        <div>Date: <?php echo e(\Carbon\Carbon::now()->format('d M, Y')); ?></div>
    </div>

    <div class="section">
        <table class="meta-table">
            <tr>
                <th>Tender Title</th>
                <td><?php echo e($tender->title); ?></td>
            </tr>
            <tr>
                <th>Category</th>
                <td style="text-transform: capitalize;"><?php echo e($tender->category); ?></td>
            </tr>
            <tr>
                <th>Tender Type</th>
                <td style="text-transform: capitalize;"><?php echo e($tender->tender_type ?? 'Open'); ?></td>
            </tr>
            <tr>
                <th>Location / Site</th>
                <td><?php echo e($tender->location ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Estimated Cost</th>
                <td>Rs. <?php echo e(isset($tender->budget) ? number_format($tender->budget, 2) : '0.00'); ?></td>
            </tr>
            <tr>
                <th>EMD Amount</th>
                <td>Rs. <?php echo e(isset($tender->emd_amount) ? number_format($tender->emd_amount, 2) : '0.00'); ?></td>
            </tr>
            <tr>
                <th>Tender Fee</th>
                <td>Rs. <?php echo e(isset($tender->tender_fee) ? number_format($tender->tender_fee, 2) : '0.00'); ?></td>
            </tr>
            <tr>
                <th>Bid Submission Start</th>
                <td><?php echo e($tender->bid_submission_start ? \Carbon\Carbon::parse($tender->bid_submission_start)->format('d M, Y') : 'Immediate'); ?>

                </td>
            </tr>
            <tr>
                <th>Submission Deadline</th>
                <td><?php echo e($tender->deadline ? \Carbon\Carbon::parse($tender->deadline)->format('d M, Y') : 'Until Filled'); ?>

                </td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Scope of Work / Description</div>
        <div class="content">
            <?php echo e($tender->description ?? 'No description provided.'); ?>

        </div>
    </div>

    <?php if($tender->technical_specifications): ?>
        <div class="section">
            <div class="section-title">Technical Specifications</div>
            <div class="content">
                <?php echo e($tender->technical_specifications); ?>

            </div>
        </div>
    <?php endif; ?>

    <div class="footer">
        <br><br><br>
        <div class="sign">
            Authorized Signatory<br>
            <?php echo e($tender->society_name ?? 'Secretary'); ?>

        </div>
    </div>
</body>

</html><?php /**PATH C:\Users\monda\Downloads\MSoft-Secure-Dashboard\backend\resources\views/tenders/pdf.blade.php ENDPATH**/ ?>