<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDocumentsToTenderBidsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tender_bids', function (Blueprint $table) {
            if (!Schema::hasColumn('tender_bids', 'documents')) {
                $table->text('documents')->nullable()->after('proposal_details');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tender_bids', function (Blueprint $table) {
            if (Schema::hasColumn('tender_bids', 'documents')) {
                $table->dropColumn('documents');
            }
        });
    }
}
