<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUnitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('units', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('society_id');
            $table->string('unit_code')->unique()->nullable();
            $table->string('unit_number'); // e.g., "A-101", "B-205"
            $table->string('wing')->nullable(); // e.g., "A", "B", "Tower 1"
            $table->integer('floor')->nullable();
            $table->enum('unit_type', ['flat', 'shop', 'office'])->default('flat');
            $table->decimal('area_sqft', 10, 2)->nullable();
            $table->decimal('monthly_maintenance', 10, 2)->default(0);
            $table->enum('status', ['occupied', 'vacant'])->default('vacant');
            $table->timestamps();

            $table->foreign('society_id')->references('id')->on('societies')->onDelete('cascade');
            $table->unique(['society_id', 'unit_number']); // Prevent duplicate unit numbers in same society
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('units');
    }
}
