<?php

namespace App\Traits;

trait ApiResponse
{
    protected function success($data = null, $message = null, $code = 200)
    {
        return response()->json([
            'status' => 'success',
            'message' => $message,
            'data' => $data
        ], $code);
    }

    protected function error($message, $code = 400, $errorDetails = null, $errorCode = null)
    {
        return response()->json([
            'status' => 'error',
            'message' => $message,
            'code' => $errorCode ?? 'API_ERROR',
            'errors' => $errorDetails
        ], $code);
    }
}
