<?php

namespace App\Services;

use App\Models\Society;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class SuperAdminService
{
    /**
     * Get global statistics for Super Admin dashboard.
     */
    public function getGlobalStats()
    {
        $totalSocieties = Society::count();
        $activeSocieties = Society::where('status', 'active')->count();
        $suspendedSocieties = Society::where('status', 'suspended')->count();

        $totalUsers = User::count(); // across all societies

        // Example: Calculate total system revenue or other metrics if needed
        // For now, let's just count total units managed
        $totalUnits = DB::table('units')->count();

        return [
            'total_societies' => $totalSocieties,
            'active_societies' => $activeSocieties,
            'suspended_societies' => $suspendedSocieties,
            'total_users' => $totalUsers,
            'total_units' => $totalUnits
        ];
    }

    /**
     * Update society status (Suspend/Activate).
     */
    public function updateSocietyStatus($societyId, $status)
    {
        if (!in_array($status, ['active', 'suspended'])) {
            throw new \InvalidArgumentException("Invalid status provided");
        }

        $society = Society::findOrFail($societyId);
        $society->status = $status;
        $society->save();

        return $society;
    }
}
