<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Unit extends Model
{
    use HasFactory;

    protected $fillable = [
        'society_id',
        'unit_code',
        'unit_number',
        'wing',
        'floor',
        'unit_type',
        'area_sqft',
        'monthly_maintenance',
        'status'
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($unit) {
            $latest = self::orderBy('id', 'desc')->first();
            $number = $latest ? (int) substr($latest->unit_code, 5) + 1 : 1;
            do {
                $code = 'SMUnt' . str_pad($number, 7, '0', STR_PAD_LEFT);
                $exists = self::where('unit_code', $code)->exists();
                if ($exists)
                    $number++;
            } while ($exists);
            $unit->unit_code = $code;
        });
    }
}
