<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Society extends Model
{
    use HasFactory;

    protected $fillable = [
        'society_code',
        'name',
        'registration_number',
        'society_photo',
        'address',
        'area',
        'city',
        'state',
        'pincode',
        'logo',
        'contact_no',
        'email',
        'configuration',
        'status',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($society) {
            $latest = self::orderBy('id', 'desc')->first();
            $number = $latest ? (int) substr($latest->society_code, 3) + 1 : 1;
            $society->society_code = 'SMS' . str_pad($number, 7, '0', STR_PAD_LEFT);
        });
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }
}
