<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Notice</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            padding: 30px;
            color: #111;
        }

        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .society-name {
            font-size: 24px;
            font-weight: bold;
            text-transform: uppercase;
            margin: 0;
            color: #000;
        }

        .sub-header {
            font-size: 14px;
            margin-top: 5px;
        }

        table.meta {
            width: 100%;
            margin-bottom: 30px;
            font-family: Arial, sans-serif;
            font-size: 14px;
        }

        .title {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            text-decoration: underline;
            text-transform: uppercase;
            margin-bottom: 30px;
        }

        .content {
            font-size: 14px;
            line-height: 1.6;
            margin-bottom: 40px;
            text-align: left;
            min-height: 200px;
            white-space: pre-wrap;
        }

        .footer {
            margin-top: 50px;
            page-break-inside: avoid;
        }

        .signature-box {
            float: right;
            width: 300px;
            text-align: right;
        }

        .sign-line {
            border-top: 1px solid #000;
            margin-top: 60px;
            padding-top: 10px;
            font-weight: bold;
            display: inline-block;
            min-width: 200px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="society-name"><?php echo e($society_name); ?></div>
        <div class="sub-header">Official <?php echo e(ucfirst($notice->type)); ?></div>
    </div>

    <table class="meta">
        <tr>
            <td align="left"><strong>Ref No:</strong>
                NOTICE/<?php echo e(date('Y', strtotime($notice->created_at))); ?>/<?php echo e($notice->id); ?></td>
            <td align="right"><strong>Date:</strong> <?php echo e(date('d F, Y', strtotime($notice->created_at))); ?></td>
        </tr>
    </table>

    <div class="title"><?php echo e($notice->title); ?></div>

    <div class="content">
        <?php echo e($notice->content); ?>

    </div>

    <div class="footer">
        <div class="signature-box">
            <div>For, <strong><?php echo e($society_name); ?></strong></div>
            <div class="sign-line">
                <?php echo e($creator_name); ?><br>
                <span style="font-size:12px; font-weight:normal;">(Authorized Signatory)</span>
            </div>
        </div>
        <div style="clear:both;"></div>
    </div>
</body>

</html><?php /**PATH C:\Users\monda\Downloads\MSoft-Secure-Dashboard\backend\resources\views/notices/pdf.blade.php ENDPATH**/ ?>