<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SocietyController;
use App\Http\Controllers\TenderController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\ComplaintController;
use App\Http\Controllers\ActivityLogController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
|
*/

Route::middleware('throttle:60,1')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);

    // Protected Routes
    Route::middleware('auth:api')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::post('/change-password', [AuthController::class, 'changePassword']);

        // Finance Routes
        Route::get('/finance', [App\Http\Controllers\FinanceController::class, 'index']);
        Route::post('/finance', [App\Http\Controllers\FinanceController::class, 'store']);
        Route::get('/finance/summary', [App\Http\Controllers\FinanceController::class, 'summary']);

        // Unit Management Routes
        Route::get('/units', [App\Http\Controllers\UnitController::class, 'index']);
        Route::post('/units', [App\Http\Controllers\UnitController::class, 'store']);
        Route::put('/units/{id}', [App\Http\Controllers\UnitController::class, 'update']);
        Route::post('/units/{id}/assign-member', [App\Http\Controllers\UnitController::class, 'assignMember']);
        Route::post('/units/{id}/vacate', [App\Http\Controllers\UnitController::class, 'vacate']);

        Route::get('/dashboard/stats', [App\Http\Controllers\DashboardController::class, 'stats']);

        // Maintenance Billing Routes
        Route::get('/maintenance/bills', [App\Http\Controllers\MaintenanceController::class, 'index']);
        Route::get('/maintenance/summary', [App\Http\Controllers\MaintenanceController::class, 'summary']); // Ensure this exists if not already
        Route::get('/maintenance/history-status', [App\Http\Controllers\MaintenanceController::class, 'historyStatus']);
        Route::post('/maintenance/generate', [App\Http\Controllers\MaintenanceController::class, 'generateBills']);
        Route::post('/maintenance/bills/{id}/pay', [App\Http\Controllers\MaintenanceController::class, 'recordPayment']);
        Route::get('/maintenance/summary', [App\Http\Controllers\MaintenanceController::class, 'summary']);

        Route::get('/me', [AuthController::class, 'me']);

        // Tender Routes (with bid management)
        Route::get('/tenders', [TenderController::class, 'index']);
        Route::post('/tenders', [TenderController::class, 'store']);
        Route::get('/tenders/{id}', [TenderController::class, 'show']);
        Route::put('/tenders/{id}', [TenderController::class, 'update']);
        Route::delete('/tenders/{id}', [TenderController::class, 'destroy']);
        Route::post('/tenders/{id}/bids', [TenderController::class, 'submitBid']);
        Route::get('/tenders/{id}/bids', [TenderController::class, 'getBids']);
        Route::post('/tenders/{id}/award/{bidId}', [TenderController::class, 'awardTender']);
        Route::post('/tenders/{id}/approve', [TenderController::class, 'approveTender']);
        Route::post('/tenders/{id}/suspend', [TenderController::class, 'suspendTender']);
        Route::post('/tenders/{id}/resume', [TenderController::class, 'resumeTender']);
        Route::get('/tenders/{id}/pdf', [TenderController::class, 'downloadPdf']);
        Route::get('/tenders/{id}/work-order', [TenderController::class, 'downloadWorkOrder']);
        Route::get('/bids/{bidId}/documents/{index}', [TenderController::class, 'downloadBidDocument']);

        // Notices
        Route::get('/notices', [NoticeController::class, 'index']);
        Route::post('/notices', [NoticeController::class, 'store']);
        Route::get('/notices/{id}', [NoticeController::class, 'show']);
        Route::put('/notices/{id}', [NoticeController::class, 'update']);
        Route::delete('/notices/{id}', [NoticeController::class, 'destroy']);
        Route::get('/notices/{id}/download', [NoticeController::class, 'downloadAttachment']);

        // Complaints
        Route::get('/complaints', [ComplaintController::class, 'index']);
        Route::post('/complaints', [ComplaintController::class, 'store']);
        Route::get('/complaints/{id}', [ComplaintController::class, 'show']);
        Route::put('/complaints/{id}', [ComplaintController::class, 'update']);
        Route::get('/complaints/{id}/download', [ComplaintController::class, 'downloadAttachment']);

        // Audit Logs
        Route::get('/logs', [ActivityLogController::class, 'index']);

        // Get vendors list for admin bid submission
        Route::get('/users/vendors', [App\Http\Controllers\UserController::class, 'getVendors']);

        // Vendors
        Route::get('/vendors', [VendorController::class, 'index']);
        Route::get('/vendors/{id}', [VendorController::class, 'show']);
        Route::post('/vendors/{id}/status', [VendorController::class, 'updateStatus']);
        Route::get('/vendors/{id}/performance', [VendorController::class, 'getPerformance']);

        Route::put('/societies/{id}/status', [SocietyController::class, 'updateStatus']);

        // Unit History & Documents
        Route::get('/units/{id}/history', [UnitController::class, 'getHistory']);
        Route::post('/units/{id}/history', [UnitController::class, 'addHistoryLog']);
        Route::post('/units/history/{logId}/upload', [UnitController::class, 'uploadHistoryDocument']);
        Route::get('/units/history/download/{filename}', [UnitController::class, 'downloadHistoryDocument']);
        Route::apiResource('societies', SocietyController::class);
        Route::get('/societies/{id}/users', [SocietyController::class, 'getUsers']);
        Route::post('/societies/{id}/users', [SocietyController::class, 'addUser']);
        Route::put('/societies/{id}/users/{userId}', [SocietyController::class, 'updateUser']);
        Route::delete('/societies/{id}/users/{userId}', [SocietyController::class, 'deleteUser']);
    });
});
