<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Work Order</title>
    <style>
        body { font-family: "Times New Roman", Times, serif; font-size: 13px; color: #000; line-height: 1.4; }
        .header-table { width: 100%; border-bottom: 2px solid #000; margin-bottom: 20px; padding-bottom: 10px; }
        .logo { max-height: 70px; }
        .society-name { font-size: 22px; font-weight: bold; text-transform: uppercase; margin: 0; }
        .society-address { font-size: 12px; margin: 5px 0; }
        
        .wo-title { text-align: center; font-size: 18px; font-weight: bold; text-decoration: underline; margin: 20px 0; text-transform: uppercase; }
        
        .meta-container { width: 100%; margin-bottom: 20px; }
        .meta-table { width: 100%; border-collapse: collapse; }
        .meta-table td { vertical-align: top; padding: 4px; }
        
        .box-container { border: 1px solid #000; padding: 10px; min-height: 100px; }
        .box-title { font-weight: bold; text-decoration: underline; margin-bottom: 5px; font-size: 14px; }
        
        .subject { font-weight: bold; margin: 20px 0; text-align: center; font-size: 14px; }
        
        .content { margin-bottom: 15px; text-align: justify; }
        
        .details-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .details-table th, .details-table td { border: 1px solid #000; padding: 8px; font-size: 12px; }
        .details-table th { background-color: #f2f2f2; text-align: center; }
        
        .terms-section { margin-top: 30px; page-break-inside: avoid; }
        .terms-title { font-weight: bold; margin-bottom: 10px; text-decoration: underline; }
        .terms-list { padding-left: 20px; list-style-type: decimal; font-size: 12px; }
        .terms-list li { margin-bottom: 5px; }

        .footer { margin-top: 50px; width: 100%; page-break-inside: avoid; }
        .sign-table { width: 100%; margin-top: 60px; }
        .sign-block { text-align: center; border-top: 1px solid #000; padding-top: 5px; width: 220px; }
        
        .page-footer { position: fixed; bottom: 0; left: 0; right: 0; text-align: center; font-size: 10px; color: #666; border-top: 1px solid #ccc; padding-top: 5px; }
    </style>
</head>
<body>
    <!-- Header -->
    <table class="header-table">
        <tr>
            <td width="15%" valign="middle" align="left">
                @if($tender->society_logo)
                    <img src="{{ $tender->society_logo }}" class="logo" alt="Logo">
                @endif
            </td>
            <td width="85%" align="center">
                <h1 class="society-name">{{ $tender->society_name ?? 'Society Management' }}</h1>
                <p class="society-address">{{ $tender->society_address ?? 'Official Address Not Available' }}</p>
            </td>
        </tr>
    </table>

    <div class="wo-title">WORK ORDER</div>

    <!-- Meta Info: To and Reference -->
    <table class="meta-container">
        <tr>
            <td width="55%">
                <div class="box-container">
                    <div class="box-title">To (Vendor Details):</div>
                    <strong>{{ $vendor->vendor_company_name ?? $vendor->name }}</strong><br>
                    @if(isset($vendor->vendor_company_name) && $vendor->name != $vendor->vendor_company_name)
                        Attn: {{ $vendor->name }}<br>
                    @endif
                    @if($vendor->house_number || $vendor->wing)
                        Address: {{ $vendor->wing ?? '' }} {{ $vendor->house_number ?? '' }}<br>
                    @endif
                    Phone: {{ $vendor->phone }}<br>
                    Email: {{ $vendor->email }}<br>
                    @if($vendor->vendor_gst_number) GSTIN: {{ $vendor->vendor_gst_number }}<br> @endif
                    @if($vendor->vendor_pan_number) PAN: {{ $vendor->vendor_pan_number }} @endif
                </div>
            </td>
            <td width="5%"></td>
            <td width="40%">
                <table class="details-table" style="margin:0;">
                    <tr>
                        <th align="left" width="40%">Work Order No:</th>
                        <td><strong>{{ $tender->tender_number }}/WO</strong></td>
                    </tr>
                    <tr>
                        <th align="left">Date:</th>
                        <td>{{ \Carbon\Carbon::now()->format('d/m/Y') }}</td>
                    </tr>
                    <tr>
                        <th align="left">Ref Tender:</th>
                        <td>{{ $tender->tender_number }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- Subject -->
    <div class="subject">
        Sub: Work Order for {{ $tender->title }} at {{ $tender->location ?? 'Society Date' }} - Reg.
    </div>

    <!-- Intro -->
    <div class="content">
        Dear Sir/Madam,<br><br>
        This has reference to your quotation submitted against our tender enquiry for the above-mentioned subject.
        We are pleased to inform you that your offer has been accepted, and we hereby award you the contract for 
        <strong>{{ $tender->title }}</strong> on the following terms and conditions:
    </div>

    <!-- Financials -->
    <table class="details-table">
        <thead>
            <tr>
                <th width="10%">Sl. No.</th>
                <th width="60%">Description of Work</th>
                <th width="30%">Amount (INR)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td align="center">1</td>
                <td>
                    <strong>{{ $tender->title }}</strong><br>
                    <span style="font-size: 11px;">Scope: {{ $bid->proposal_details ?? 'As per tender scope and submitted proposal.' }}</span>
                </td>
                <td align="right" valign="top"><strong>{{ number_format($bid->quoted_amount, 2) }}</strong></td>
            </tr>
            <tr>
                <td colspan="2" align="right"><strong>Total Contract Value</strong></td>
                <td align="right"><strong>{{ number_format($bid->quoted_amount, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
    <div style="text-align: right; font-size: 12px; font-style: italic;">
        (Amount in words: {{ class_exists('NumberFormatter') ? ucfirst((new \NumberFormatter('en', \NumberFormatter::SPELLOUT))->format($bid->quoted_amount)) . ' Rupees Only' : 'INR ' . $bid->quoted_amount . ' Only' }})
    </div>

    <!-- Terms -->
    <div class="terms-section">
        <div class="terms-title">Terms and Conditions:</div>
        <ol class="terms-list">
            <li><strong>Completion Period:</strong> The entire work shall be completed on or before {{ $tender->deadline ? \Carbon\Carbon::parse($tender->deadline)->addDays(30)->format('d/m/Y') : 'agreed timeline' }}. Time is the essence of this contract.</li>
            <li><strong>Payment Terms:</strong> Payment will be released within 15 days after satisfactory completion of work and submission of certified bill unless otherwise specified in tender.</li>
            <li><strong>Taxation:</strong> The rates mentioned above are inclusive of all taxes, duties, and levies unless explicitly stated otherwise. TDS will be deducted as per applicable rates.</li>
            <li><strong>Quality of Work:</strong> Determine materials and workmanship shall be of the highest standard. Any defect found during the defect liability period shall be rectified by the vendor at their own cost.</li>
            <li><strong>Safety:</strong> The vendor shall be solely responsible for the safety of their workers and compliance with labor laws.</li>
            <li><strong>Jurisdiction:</strong> Any dispute arising out of this order shall be subject to the jurisdiction of local courts.</li>
        </ol>
    </div>

    <div class="content">
        Please sign and return the duplicate copy of this Work Order as a token of your acceptance.
    </div>

    <!-- Signatures -->
    <table class="sign-table">
        <tr>
            <td align="left">
                <div class="sign-block" style="text-align: left; border: none;">
                    <strong>Accepted By:</strong><br><br><br>
                    <div style="border-top:1px solid #000; width: 200px;">
                        Authorized Signatory<br>
                        (With Rubber Stamp)<br>
                        <strong>{{ $vendor->vendor_company_name ?? $vendor->name }}</strong>
                    </div>
                </div>
            </td>
            <td align="right">
                <div class="sign-block" style="float: right;">
                    For <strong>{{ $tender->society_name ?? 'Society Name' }}</strong><br><br><br><br>
                    Authorized Signatory
                </div>
            </td>
        </tr>
    </table>

    <div class="page-footer">
        This is a computer-generated document. No signature is required. | Generated by MSoft Secure Dashboard
    </div>
</body>
</html>