<?php

namespace Database\Seeders;

use App\Models\Society;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SocietySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // 1. Create a Super Admin (No society_id)
        User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@msoft.com',
            'password' => Hash::make('superpassword'),
            'role' => 'super_admin',
            'society_id' => null
        ]);

        // 2. Create Galaxy residency Society
        $galaxy = Society::create([
            'name' => 'Galaxy Residency',
            'address' => '123 Galaxy St, Future City',
            'contact_no' => '9876543210',
            'email' => 'contact@galaxy.com',
        ]);

        // Create Society Admin for Galaxy
        User::create([
            'name' => 'Galaxy Admin',
            'email' => 'admin@galaxy.com',
            'password' => Hash::make('adminpassword'),
            'role' => 'society_admin',
            'society_id' => $galaxy->id
        ]);

        // 3. Create Sunshine Society
        $sunshine = Society::create([
            'name' => 'Sunshine Heights',
            'address' => '456 Solar Ave, Sunny Town',
            'contact_no' => '1234567890',
            'email' => 'info@sunshine.com',
        ]);

        // Create Society Admin for Sunshine
        User::create([
            'name' => 'Sunshine Admin',
            'email' => 'admin@sunshine.com',
            'password' => Hash::make('adminpassword'),
            'role' => 'society_admin',
            'society_id' => $sunshine->id
        ]);
    }
}
