<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingColumnsToTendersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tenders', function (Blueprint $table) {
            if (!Schema::hasColumn('tenders', 'tender_type')) {
                $table->enum('tender_type', ['open', 'limited', 'invited'])->default('open')->after('title');
            }
            if (!Schema::hasColumn('tenders', 'location')) {
                $table->string('location')->nullable()->after('tender_type');
            }
            if (!Schema::hasColumn('tenders', 'emd_amount')) {
                $table->decimal('emd_amount', 10, 2)->default(0)->after('budget');
            }
            if (!Schema::hasColumn('tenders', 'tender_fee')) {
                $table->decimal('tender_fee', 10, 2)->default(0)->after('emd_amount');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tenders', function (Blueprint $table) {
            //
        });
    }
}
