<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTendersSystemTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Tenders Table
        Schema::create('tenders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('society_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->string('tender_number', 64)->unique()->nullable();
            $table->string('title');
            $table->enum('category', ['construction', 'maintenance', 'services', 'supplies'])->default('maintenance');
            $table->enum('tender_type', ['open', 'limited', 'invited'])->default('open');
            $table->string('location')->nullable();
            $table->text('description')->nullable();
            $table->text('technical_specifications')->nullable();
            $table->decimal('budget', 15, 2)->default(0);
            $table->decimal('emd_amount', 15, 2)->default(0);
            $table->decimal('tender_fee', 15, 2)->default(0);
            $table->decimal('minimum_bid_amount', 15, 2)->nullable();
            $table->decimal('maximum_bid_amount', 15, 2)->nullable();
            $table->date('deadline')->nullable();
            $table->timestamp('bid_submission_start')->nullable();
            $table->timestamp('bid_submission_end')->nullable();
            $table->string('status')->default('open');
            $table->enum('approval_status', ['draft', 'open', 'closed', 'awarded'])->default('draft');
            $table->boolean('is_suspended')->default(false);
            $table->text('suspended_reason')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('awarded_vendor_id')->nullable();
            $table->timestamps();

            $table->foreign('society_id')->references('id')->on('societies')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('awarded_vendor_id')->references('id')->on('users')->onDelete('set null');
        });

        // Tender Bids Table
        Schema::create('tender_bids', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tender_id');
            $table->unsignedBigInteger('vendor_id'); // FK to users table (role=vendor)
            $table->decimal('quoted_amount', 15, 2);
            $table->text('proposal_details')->nullable();
            $table->enum('status', ['submitted', 'accepted', 'rejected'])->default('submitted');
            $table->timestamps();

            $table->foreign('tender_id')->references('id')->on('tenders')->onDelete('cascade');
            $table->foreign('vendor_id')->references('id')->on('users')->onDelete('cascade');
            $table->unique(['tender_id', 'vendor_id']); // One bid per vendor per tender
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tender_bids');
        Schema::dropIfExists('tenders');
    }
}
