<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtraFieldsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('user_code')->unique()->nullable()->after('id');

            // Member specific fields
            $table->string('house_number')->nullable();
            $table->string('wing')->nullable();
            $table->string('member_type')->nullable(); // owner, tenant

            // Employee specific fields
            $table->string('employee_id_code')->nullable();
            $table->string('designation')->nullable();
            $table->date('joining_date')->nullable();

            // Vendor specific fields
            $table->string('vendor_id_code')->nullable();
            $table->string('vendor_type')->nullable();
            $table->text('service_description')->nullable();

            // Professional vendor management
            $table->enum('vendor_status', ['active', 'inactive', 'suspended', 'blocked'])->default('active');
            $table->string('vendor_company_name')->nullable();
            $table->string('vendor_gst_number')->nullable();
            $table->string('vendor_pan_number')->nullable();
            $table->date('vendor_registration_date')->nullable();
            $table->decimal('vendor_rating', 3, 2)->default(0);
            $table->integer('vendor_completed_projects')->default(0);
            $table->text('blocked_reason')->nullable();
            $table->date('suspended_until')->nullable();

            $table->string('phone')->nullable();
            $table->string('photo')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
}
