-- MSoft Secure Dashboard - Database Export
-- Target: MySQL/MariaDB

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `role` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user',
  `remember_token` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `password`, `role`, `created_at`, `updated_at`) VALUES
(1, 'Admin User', 'admin@msoft.com', '$2y$10$ZxR3OBqm/2moo/NZPr7X2enUlPfxZIDmKOrncMPyZ9Jyrg3TqlbQe', 'admin', NOW(), NOW()),
(2, 'Clerk User', 'clerk@msoft.com', '$2y$10$UIqWBAmyZ9GxlOr/UnNJQey9xp7a85zoOzUhrljbl24d8Vd3bcWwC', 'clerk', NOW(), NOW());

-- Note: The passwords are 'password123' and 'clerkpassword' respectively (using standard Laravel bcrypt hashes).

COMMIT;
