<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    /**
     * Get all vendors for admin bid submission
     */
    public function getVendors(Request $request)
    {
        $user = Auth::user();

        // Only admins can access this
        if (!in_array($user->role, ['society_admin', 'secretary'])) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized'
            ], 403);
        }

        $vendors = DB::table('users')
            ->where('role', 'vendor')
            ->where('is_active', true)
            ->select('id', 'name', 'email', 'phone')
            ->orderBy('name')
            ->get();

        return response()->json([
            'status' => 'success',
            'data' => $vendors
        ]);
    }
}
