<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    // GET /api/dashboard/stats
    public function stats()
    {
        $user = Auth::user();
        if (!$user || !$user->society_id) {
            return response()->json(['status' => 'error', 'message' => 'Unauthorized'], 403);
        }

        $societyId = $user->society_id;

        // 1. Total Members
        $totalMembers = DB::table('users')
            ->where('society_id', $societyId)
            ->where('role', 'member')
            ->count();

        // 2. Total Units
        $totalUnits = DB::table('units')
            ->where('society_id', $societyId)
            ->count();

        $occupiedUnits = DB::table('units')
            ->where('society_id', $societyId)
            ->where('status', 'occupied')
            ->count();

        // 3. Maintenance Overview (Pending Amount)
        $pendingMaintenance = DB::table('maintenance_bills')
            ->where('society_id', $societyId)
            ->where('status', 'pending')
            ->sum('amount');

        // 4. Open Tenders
        $openTenders = DB::table('tenders')
            ->where('society_id', $societyId)
            ->where('status', 'open')
            ->count();

        // 5. Active Vendors
        $activeVendors = DB::table('users') // Assuming vendors are users with role 'vendor' linked to society
            // Note: In some systems vendor linkage might be different, but sticking to User model based on previous context
            ->where('society_id', $societyId)
            ->where('role', 'vendor')
            ->where('vendor_status', 'active')
            ->count();

        return response()->json([
            'status' => 'success',
            'data' => [
                'members' => $totalMembers,
                'total_units' => $totalUnits,
                'occupied_units' => $occupiedUnits,
                'pending_maintenance' => $pendingMaintenance,
                'open_tenders' => $openTenders,
                'active_vendors' => $activeVendors,
                'maintenance_generated' => DB::table('maintenance_bills')
                    ->where('society_id', $societyId)
                    ->where('billing_month', now()->format('Y-m'))
                    ->exists()
            ]
        ]);
    }
}
